/*
 * Decompiled with CFR 0.152.
 */
package noppes.npcs.client.gui;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Vector;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponentTranslation;
import noppes.npcs.client.Client;
import noppes.npcs.client.gui.util.GuiCustomScroll;
import noppes.npcs.client.gui.util.GuiNpcButton;
import noppes.npcs.client.gui.util.GuiNpcSlider;
import noppes.npcs.client.gui.util.GuiNpcTextField;
import noppes.npcs.client.gui.util.ICustomScrollListener;
import noppes.npcs.client.gui.util.IGuiCustomScroll;
import noppes.npcs.client.gui.util.IGuiNpcButton;
import noppes.npcs.client.gui.util.IGuiNpcSlider;
import noppes.npcs.client.gui.util.IGuiNpcTextField;
import noppes.npcs.client.gui.util.IScrollData;
import noppes.npcs.client.gui.util.ISliderListener;
import noppes.npcs.client.gui.util.ITextfieldListener;
import noppes.npcs.client.gui.util.SubGuiInterface;
import noppes.npcs.constants.EnumPacketServer;
import noppes.npcs.entity.data.Resistances;
import noppes.npcs.util.Util;

public class SubGuiNpcResistanceProperties
extends SubGuiInterface
implements ICustomScrollListener,
ISliderListener,
IScrollData,
ITextfieldListener {
    private final Resistances resistances;
    private final Map<String, String> data = new HashMap<String, String>();
    private GuiCustomScroll scroll;
    private String select = "";

    public SubGuiNpcResistanceProperties(Resistances resist) {
        this.setBackground("menubg.png");
        this.xSize = 256;
        this.ySize = 216;
        this.closeOnEsc = true;
        this.resistances = resist;
        Client.sendData(EnumPacketServer.GetResistances, new Object[0]);
    }

    @Override
    public void buttonEvent(IGuiNpcButton button) {
        if (button.getID() == 66) {
            this.close();
        }
    }

    @Override
    public void func_73866_w_() {
        int t;
        super.func_73866_w_();
        ArrayList<String> names = new ArrayList<String>();
        ArrayList<String> notList = new ArrayList<String>();
        HashMap<String, String> mapSfx = new HashMap<String, String>();
        for (String string : this.data.keySet()) {
            if (this.resistances.data.containsKey(this.data.get(string))) {
                names.add(string);
                float v = 2.0f - this.resistances.data.get(this.data.get(string)).floatValue();
                t = (int)(v * -100.0f + 100.0f);
                mapSfx.put(string, (t == 0 ? "" : '\u00a7' + (t < 0 ? "c" : "a+")) + t + "%");
                continue;
            }
            String key = "\u00a77" + string;
            notList.add(key);
            mapSfx.put(key, "\u00a770%");
        }
        Collections.sort(names);
        Collections.sort(notList);
        names.addAll(notList);
        if (this.select.isEmpty() && !names.isEmpty()) {
            this.select = Util.instance.deleteColor((String)names.get(0));
        }
        ArrayList<String> suffixes = new ArrayList<String>();
        for (String key : names) {
            suffixes.add((String)mapSfx.get(key));
        }
        if (this.scroll == null) {
            this.scroll = new GuiCustomScroll(this, 0);
            this.scroll.setSize(248, 176);
        }
        this.scroll.guiLeft = this.guiLeft + 4;
        this.scroll.guiTop = this.guiTop + 4;
        this.scroll.setSelected(this.npc.linkedName);
        this.scroll.setListNotSorted(names);
        this.scroll.setSuffixes(suffixes);
        this.scroll.setSelected(this.select);
        this.addScroll(this.scroll);
        int n = this.guiTop + this.ySize - 34;
        if (!this.select.isEmpty()) {
            float v = 2.0f - this.resistances.get(this.data.get(this.select));
            t = (int)(v * -100.0f + 100.0f);
            GuiNpcSlider slider = new GuiNpcSlider(this, 0, this.guiLeft + 4, n, (t == 0 ? "" : '\u00a7' + (t < 0 ? "c" : "a+")) + String.valueOf(t).replace(".", ",") + "%", (float)t * 0.001667f + 0.833333f);
            slider.field_146121_g = 14;
            slider.field_146120_f = 248;
            TextComponentTranslation mes = new TextComponentTranslation("stats.hover.resist", new Object[]{Util.instance.deleteColor(this.select)});
            if (t == 0) {
                mes.func_150257_a((ITextComponent)new TextComponentTranslation("stats.hover.resist.0", new Object[0]));
            } else if (t < 0) {
                mes.func_150257_a((ITextComponent)new TextComponentTranslation("stats.hover.resist.1", new Object[]{"" + t}));
            } else {
                mes.func_150257_a((ITextComponent)new TextComponentTranslation("stats.hover.resist.2", new Object[]{"" + t}));
            }
            slider.setHoverText(mes.func_150254_d(), new Object[0]);
            this.addSlider(slider);
            GuiNpcTextField textField = new GuiNpcTextField(0, this, this.guiLeft + 4, n + 16, 60, 14, "" + t);
            textField.setMinMaxDefault(-500L, 100L, t);
            textField.setHoverText(mes.func_150254_d(), new Object[0]);
            this.addTextField(textField);
        }
        GuiNpcButton button = new GuiNpcButton(66, this.guiLeft + 190, n + 16, 60, 14, "gui.done");
        button.setHoverText("hover.back", new Object[0]);
        this.addButton(button);
    }

    @Override
    public void mouseDragged(IGuiNpcSlider slider) {
        float n = 0.8333333f;
        int t = Math.round(slider.getSliderValue() * 600.0f - 500.0f);
        slider.setDisplayString(slider.getSliderValue() == n ? "" : '\u00a7' + (slider.getSliderValue() < n ? "c" : "a+") + String.valueOf(t).replace(".", ",") + "%");
        TextComponentTranslation mes = new TextComponentTranslation("stats.hover.resist", new Object[]{Util.instance.deleteColor(this.select)});
        if (t == 0) {
            mes.func_150257_a((ITextComponent)new TextComponentTranslation("stats.hover.resist.0", new Object[0]));
        } else if (t < 0) {
            mes.func_150257_a((ITextComponent)new TextComponentTranslation("stats.hover.resist.1", new Object[]{"" + t}));
        } else {
            mes.func_150257_a((ITextComponent)new TextComponentTranslation("stats.hover.resist.2", new Object[]{"" + t}));
        }
        slider.setHoverText(mes.func_150254_d(), new Object[0]);
        if (this.getTextField(0) != null) {
            this.getTextField(0).setFullText("" + t);
            this.getTextField(0).setHoverText(mes.func_150254_d(), new Object[0]);
        }
    }

    @Override
    public void mousePressed(IGuiNpcSlider slider) {
    }

    @Override
    public void mouseReleased(IGuiNpcSlider slider) {
        if (!this.data.containsKey(this.select)) {
            return;
        }
        this.setValue(this.data.get(this.select), (int)(slider.getSliderValue() * 600.0f - 500.0f));
    }

    @Override
    public void setData(Vector<String> list, HashMap<String, Integer> dataMap) {
        this.data.clear();
        for (String name : list) {
            String trName = Util.instance.deleteColor(new TextComponentTranslation("resistance." + name.toLowerCase(), new Object[0]).func_150254_d());
            if (trName.equals("resistance." + name.toLowerCase())) {
                trName = name;
            }
            this.data.put(trName, name);
        }
        this.func_73866_w_();
    }

    @Override
    public void setSelected(String select) {
    }

    @Override
    public void scrollClicked(int mouseX, int mouseY, int mouseButton, IGuiCustomScroll scroll) {
        if (!scroll.hasSelected() || !this.data.containsKey(Util.instance.deleteColor(scroll.getSelected()))) {
            return;
        }
        this.select = Util.instance.deleteColor(scroll.getSelected());
        this.func_73866_w_();
    }

    @Override
    public void scrollDoubleClicked(String select, IGuiCustomScroll scroll) {
    }

    @Override
    public void unFocused(IGuiNpcTextField textField) {
        if (!this.data.containsKey(this.select)) {
            return;
        }
        this.setValue(this.data.get(this.select), textField.getInteger());
    }

    private void setValue(String damageType, int value) {
        if (!(value != 0 || damageType.equals("arrow") || damageType.equals("thrown") || damageType.equals("player") || damageType.equals("mob") || damageType.equals("explosion") || damageType.equals("explosion.player") || damageType.equals("knockback"))) {
            this.resistances.data.remove(damageType);
        } else {
            this.resistances.data.put(damageType, Float.valueOf((float)value * 0.01f + 1.0f));
        }
        this.func_73866_w_();
    }
}

